; Oszillator auf eine neue Frequenz setzen
; Interrupt darf noch nicht erlaubt sein
; in den Configregister muss Taktumschaltung erlaubt sein
; 17.03.2020 = auf 30 MIPS = Zykluszeit von 32ns

.global OszillatorSetzen

OszillatorSetzen:
	mov		#32,w0		;63 M=65
	mov		w0,PLLFBD
	mov		#0b00000000,w0	; N2=2 N1=3
	mov		w0,CLKDIV	
	
	MOV #0x1,w0
	disi	#15	
; OSCCONH (high byte) Unlock Sequence
	MOV #OSCCONH, w1
	MOV #0x78, w2
	MOV #0x9A, w3
	MOV.B w2, [w1] ; Write 0x78
	MOV.B w3, [w1] ; Write 0x9A
; Set New Oscillator Selection
	MOV.B w0, [w1]
; Place 0x01 in W0 for setting clock switch enabled bit
	MOV #0x01, w0
;	OSCCONL (low byte) Unlock Sequence
	MOV #OSCCONL, w1
	MOV #0x46, w2
	MOV #0x57, w3
	MOV.B w2, [w1] ; Write 0x46
	MOV.B w3, [w1] ; Write 0x57
; Enable Clock Switch
	BSET OSCCON, #0; Request Clock Switching by Setting OSWEN bit
wait:
	btsc OSCCONL, #0
	bra wait
	return
